```plantuml
@startuml

skin rose

actor User
participant RestAPI
participant RegisterAPI
database Redis
database DB

== Login ==

User -> RestAPI: Login(Email, Passwort)
RestAPI --> RestAPI: Login(Email, Password)
RestAPI --> RestAPI: Generate TempToken
RestAPI -> Redis: SET TempToken(CustomerInfo) TTL=120s
RestAPI -> User: TempToken

== OTP Recovery ==

User -> RegisterAPI: OTP_Recovery(TempToken)
RegisterAPI -> Redis: GET TempToken
RegisterAPI --> RegisterAPI: Generate Captcha
RegisterAPI -> User: Captcha-Bild

== Captcha ==

User -> RegisterAPI: Solve_Captcha(TempToken, Captcha-Code)
RegisterAPI --> RegisterAPI: Validate Captcha

RegisterAPI -> User: RecoveryContacts[]
User -> RegisterAPI: Recover(TempToken, RecoveryContacts[0])

== Send RecoveryToken ==

RegisterAPI --> RegisterAPI: Generate RecoveryToken
RegisterAPI -> DB: SET CustomerInfo(RecoveryToken)
RegisterAPI -> User: Send_SMS(RecoveryToken)

== Initialize new OTP ==

User -> RegisterAPI: Initialize_OTP(TempToken, RecoveryToken)
RegisterAPI -> Redis: SET CustomerInfo(OTP-Secret) TTL=?
RegisterAPI -> Redis: GET TempToken(CustomerInfo)
RegisterAPI -> DB: GET CustomerInfo(RecoveryToken)
RegisterAPI --> RegisterAPI: Validate RecoveryToken
RegisterAPI --> RegisterAPI: Generate OTP-Secret
RegisterAPI -> User: OTP-Secret
User --> User: Scan QR-Code/OTP-Secret
User --> User: Generate_OTP(OTP-Secret)
User -> RegisterAPI: Validate_OTP(TempToken, OTP-Code)
RegisterAPI -> Redis: GET TempToken(CustomerInfo)
RegisterAPI -> Redis: GET CustomerInfo(OTP-Secret)
RegisterAPI --> RegisterAPI: Validate_OTP(OTP-Secret, OTP-Code)
RegisterAPI -> DB: UpdateOTP(CustomerInfo, OTP-Secret)
RegisterAPI -> User: OK


@enduml
```